/*
 * Set internal or external clock on a ppsifc card.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <fcntl.h>
#include <ctype.h>
#include <sys/types.h>
#include <sys/time.h>
#include <unistd.h>
#include <signal.h>
#include <sys/param.h>
#include <sys/ioctl.h>
#include <sys/ttycom.h>
#include <machine/console.h>
#include <machine/cpufunc.h>
#include "ppsclock.h"


/*
 * Main entrypoint, process command line args
 * and then set ps ifc clock mode and optionally
 * also the internal clock frequency.
 */
int main( int argc, char *argv[] )
{
  int pVal;
  int Freq = -1;
  int PpsFd;

  if( argc < 2 ) {
    fprintf( stderr, "%s ext/int [clock freq]\n", argv[ 0 ] );
    exit( 1 );
  }
  else {
    if( strcasecmp( argv[ 1 ], "ext" ) == 0 )
      pVal = 0;
    else if( strcasecmp( argv[ 1 ], "int" ) == 0 )
      pVal = 1;
    else {
      fprintf( stderr, "%s ext/int [clock freq]\n", argv[ 0 ] );
      exit( 1 );
    }
    if( argc > 2 ) {
      if( sscanf( argv[ 2 ], "%d", &Freq ) != 1 ) {
	fprintf( stderr, "%s ext/int [clock freq]\n", argv[ 0 ] );
	exit( 1 );
      }
    }
  }
  if( ( PpsFd = open( "/dev/ppsd0", O_RDWR ) ) < 0 ) {
    printf( "%s: Can't open /dev/ppsd0\n", argv[ 0 ] );
    exit( 1 );
  }
  if (ioctl(PpsFd, CIOSETCLK, (caddr_t)&pVal) < 0) {
    printf( "%s: Can't set clock mode\n", argv[ 0 ] );
    close( PpsFd );
    exit( 1 );
  }
  if( Freq > 0 ) {
    if (ioctl(PpsFd, CIOSETHZ, (caddr_t)&Freq) < 0) {
      printf( "%s: Can't set clock frequency\n", argv[ 0 ] );
      close( PpsFd );
      exit( 1 );
    }
  }
  close( PpsFd );
  return 0;

}
