#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#include <signal.h>
#include <time.h>
#include <sys/time.h>
#include <sys/ioctl.h>
#include "ppsclock.h"

int PpsFd;


/*
 * Terminate the program.
 */
static void Terminate( int sig )
{

  signal(SIGTERM, SIG_DFL);
  close( PpsFd );
  exit( 0 );

}

int main( int argc, char *argv[] )
{
  struct timeval tm;
  struct ppsclockev ClockEv;
  struct ppsstat ClockStat;
  struct ppsDebug ppsDbg;
  int MicroStep, PpsOutput;
  int SleepVal, getDebug, nTime;
  long Diff;
  char *tString;

  if( argc < 2 ) {
    printf( "Usage: %s #seconds [-d]\n",
	    argv[ 0 ] );
    exit( 1 );
  }
  if( sscanf( argv[ 1 ], "%d", &SleepVal ) != 1 ) {
    printf( "Usage: %s #seconds [-d]\n", argv[ 0 ] );
    exit( 1 );
  }
  if( SleepVal < 1 ) {
    printf( "Usage: %s #seconds [-d]\n", argv[ 0 ] );
    exit( 1 );
  }
  if( argc > 2 ) {
    if( strcmp( argv[ 2 ], "-d" ) == 0 ) {
      getDebug = 1;
    }
    else {
      printf( "Usage: %s #seconds [-d]\n", argv[ 0 ] );
      exit( 1 );
    }
  }
  else {
    getDebug = 0;
  }
  if( ( PpsFd = open( "/dev/ppsd0", O_RDWR ) ) < 0 ) {
    printf( "%s: Can't open /dev/ppsd0\n", argv[ 0 ] );
    exit( 1 );
  }
  (void)signal(SIGTERM, Terminate);
  (void)signal(SIGINT, Terminate);
  (void)signal(SIGQUIT, Terminate);
  for( ; ; ) {
    if (ioctl(PpsFd, CIOGETEV, (caddr_t)&ClockEv) < 0) {
      printf( "%s: Can't read ClockEvent\n", argv[ 0 ] );
      close( PpsFd );
      exit( 1 );
    }
    if (ioctl(PpsFd, CIOGETSTEP, (caddr_t)&MicroStep) < 0) {
      printf( "%s: Can't read MicroStep\n", argv[ 0 ] );
      close( PpsFd );
      exit( 1 );
    }
    if (ioctl(PpsFd, CIOGETPPS, (caddr_t)&PpsOutput) < 0) {
      printf( "%s: Can't read PpsOutput\n", argv[ 0 ] );
      close( PpsFd );
      exit( 1 );
    }
    if (ioctl(PpsFd, CIOGETSTAT, (caddr_t)&ClockStat) < 0) {
      printf( "%s: Can't read ClockStat\n", argv[ 0 ] );
      close( PpsFd );
      exit( 1 );
    }
    if( getDebug ) {
      if (ioctl(PpsFd, CIOGETDBG, (caddr_t)&ppsDbg) < 0) {
        printf( "%s: Can't readdebug data\n", argv[ 0 ] );
        close( PpsFd );
        exit( 1 );
      }
    }

    Diff = ClockEv.tv.tv_usec;
    if( Diff > 500000000L )
      Diff -= 1000000000L;

    gettimeofday( &tm, NULL );
    tString = asctime( localtime( (time_t *)(&tm.tv_sec) ) );
    tString[ strlen( tString ) - 1 ] = '\0';
    printf( "%s Diff : %7ld  Micro : %d  Pps : %d\n",
	    tString, Diff, MicroStep, PpsOutput );
    printf( "MinSys : %d MaxSys : %d MinHw : %d MaxHw : %d\n",
	    ClockStat.minsys, ClockStat.maxsys,
	    ClockStat.minhw, ClockStat.maxhw );
    if( getDebug ) {
      if( ppsDbg.nanoTime > 500000000L )
        nTime = ppsDbg.nanoTime - 1000000000L;
      else
        nTime = ppsDbg.nanoTime;
      printf( "Last Latency count : %d Last Nanotime : %ld Computed : %ld\n",
              ppsDbg.Latency, nTime, nTime - (ppsDbg.Latency * 100) );
    }
    fflush( stdout );
    sleep( SleepVal );
  }
  return 0;
}
