#include <fcntl.h>
#include <stdlib.h>
#include <unistd.h>
#include <time.h>
#include <signal.h>
#include <sys/ioctl.h>
#include <sys/time.h>
#include <machine/console.h>
#include <machine/cpufunc.h>
#include <stdio.h>
#include <errno.h>
#include "ppsclock.h"

#define CLKPORT		0x3e0
#ifndef PPS_MHZ
# define PPS_MHZ	10
#endif
#define MHZ_PERIOD	(1000/PPS_MHZ)
#define PPS_BYTE0       0
#define PPS_BYTE1       1
#define PPS_BYTE2       2
#define PPS_BYTE3       3
#define PPS_BYTE4       4
#define PPS_BYTE5       5
#define PPS_EN_LATCH    3
#define PPS_DIS_LATCH   4
#define PPS_DIS_IRQ     5
#define PPS_EN_IRQ      6
#define PPS_RES_IRQ     7


int main(argc, argv)
int argc;
char *argv[];

{
  int Position, ttyFd;

  if( argc < 2 ) {
    printf( "Usage: %s nanoseconds ( position relative pps input ).\n",
	    argv[ 0 ] );
    exit( 1 );
  }
  if( sscanf( argv[ 1 ], "%d", &Position ) != 1 ) {
    printf( "Usage: %s nanoseconds ( position relative pps input ).\n",
	    argv[ 0 ] );
    exit( 1 );
  }
#if 0
  if( ( ttyFd = open( "/dev/ttyv0", O_RDWR ) ) < 0 ) {
    printf( "%s: Can't open /dev/ttyv0, errno : %d\n", argv[ 0 ], errno );
    exit( 1 );
  }
  if( ioctl( ttyFd, KDENABIO, 0 ) < 0 ) {
    printf( "%s: Can't acquire iopl, errno : %d\n", argv[ 0 ], errno );
    exit( 1 );
  }
  Position /= MHZ_PERIOD;
  Position -= 2;
  if( Position > 0 )
    Position = -Position;
  else /* if( Position < 0 ) */
    Position = -(PPS_MHZ * 1000000) - Position;

  printf( "Writing %d to microstepper\n", Position );
  outb( CLKPORT + PPS_BYTE3, Position & 0xff );
  outb( CLKPORT + PPS_BYTE4, ( Position >> 8 ) & 0xff );
  outb( CLKPORT + PPS_BYTE5, ( Position >> 16 ) & 0xff );
  close( ttyFd );
#else
  if( ( ttyFd = open( "/dev/ppsd0", O_RDWR ) ) < 0 ) {
    printf( "%s: Can't open /dev/ppsd0, errno : %d\n", argv[ 0 ], errno );
    exit( 1 );
  }
  if (ioctl(ttyFd, CIOSETSTEP, (caddr_t)&Position) < 0) {
    printf( "%s: Can't set MicroStep, errno : %d\n", argv[ 0 ], errno );
    close( ttyFd );
    exit( 1 );
  }
#endif
  return 0;
}
