/*
 * File : ts.c
 *
 * Date : 99-01-19
 */

#include <stdio.h>
#include <stdlib.h>
#include <signal.h>
#include <errno.h>
#include <unistd.h>
#include <string.h>
#include <time.h>
#include <ctype.h>
#include <netdb.h>

#include <sys/types.h>
#include <sys/time.h>
#include <sys/socket.h>
#include <sys/ioctl.h>
#include <sys/file.h>

#include <net/if.h>
#include <netinet/in.h>
#include <netinet/in_systm.h>
#include <netinet/ip.h>
#include <netinet/in.h>
#include <netinet/udp.h>
#include <netinet/tcp.h>
#include <netinet/ip_icmp.h>
#include <arpa/inet.h>

#define TS_PORT 1999

struct TspPacket { struct timeval	SndTime;
		   struct timeval	RcvTime;
};

void CheckRcvdAnswer( int Sock, struct sockaddr_in *Sa,
		      unsigned char *Packet, int Length )
{
  struct timeval tmvl;
  struct TspPacket *TspPnt;
  int sTime, rTime, i, j;

  gettimeofday( &tmvl, NULL );
  TspPnt = (struct TspPacket *)(Packet);
  i = ntohl( TspPnt->SndTime.tv_usec );
  j = ntohl( TspPnt->RcvTime.tv_usec );
  if( j < i )
    j += 1000000;

  sTime = j - i;
  i = tmvl.tv_usec;
  j = ntohl( TspPnt->RcvTime.tv_usec );
  if( i < j )
    i += 1000000;

  rTime = i - j;

  printf( "Send %d\nReceive %d\n", sTime, rTime );
  fflush( stdout );

}


int main( int argc, char *argv[] )
{
  fd_set Fds;
  struct sockaddr_in LocSa, Sa;
  int on = 1;
  int Sock, i, Length;
  struct timeval tmvl;
  struct TspPacket *TspPnt;
  struct hostent *Host;
  unsigned char InputBuffer[ 1024 ];


  if( argc < 2 ) {
    printf( "usage: %s hostname\n", argv[ 0 ] );
    exit( 1 );
  }
  if( ( Host = gethostbyname( argv[ 1 ] ) ) == NULL ) {
    printf( "host %s is unknown\n", argv[ 1 ] );
    exit( 1 );
  }
  /*
   * Create socket.
   */
  Sock = socket(AF_INET, SOCK_DGRAM, 0);
  if( Sock < 0 ) {
    printf( "Can't create socket, errno : %d", errno );
    exit( 1 );
  }
  bzero( &LocSa, sizeof LocSa );
  LocSa.sin_len = sizeof( struct sockaddr_in );
  LocSa.sin_family = AF_INET;
  LocSa.sin_addr.s_addr = INADDR_ANY;
  LocSa.sin_port =  0;
  if( bind( Sock, (struct sockaddr *)(&LocSa), sizeof LocSa ) < 0 ) {
    printf( "Can't bind socket, errno : %d", errno );
    close( Sock );
    exit( 1 );
  }
  /*
   * Eternal loop.
   */
  while( 1 ) {
    bzero( &Sa, sizeof Sa );
    Sa.sin_len = sizeof( struct sockaddr_in );
    Sa.sin_family = AF_INET;
    Sa.sin_addr.s_addr = *((u_int32_t *)(Host->h_addr_list[ 0 ]));
    Sa.sin_port =  htons( TS_PORT );

    gettimeofday( &tmvl, NULL );
    TspPnt = (struct TspPacket *)(InputBuffer);
    TspPnt->SndTime.tv_sec = htonl( tmvl.tv_sec );
    TspPnt->SndTime.tv_usec = htonl( tmvl.tv_usec );
    TspPnt->RcvTime.tv_sec = 0;
    TspPnt->RcvTime.tv_usec = 0;
    if( sendto( Sock, InputBuffer, sizeof( struct TspPacket ), 0,
        (struct sockaddr *)(&Sa), sizeof Sa ) != sizeof( struct TspPacket ) ) {
      printf( "Can't send request, errno : %d", errno );
      exit( 1 );
    }
    FD_ZERO( &Fds );
    FD_SET( Sock, &Fds );
    if( ( i = select( FD_SETSIZE, &Fds, NULL, NULL, NULL ) ) < 0 ) {
      printf( "select failed with errno : %d", errno );
      continue;
    }
    if( FD_ISSET( Sock, &Fds ) ) {
      /*
       * Answer received.
       */
      i = sizeof Sa;
      Length = recvfrom( Sock, InputBuffer, sizeof InputBuffer, 0,
		         (struct sockaddr *)(&Sa), &i );
      if( Length < 0 ) {
        printf( "recvfrom failed with errno : %d", errno );
        continue;
      }
      CheckRcvdAnswer( Sock, &Sa, InputBuffer, Length );
    }
    sleep( 1 );
  }
  return 0;
}
