/*
 * Microapi header file.
 */

#ifndef _MICROAPI_H_
#define _MICROAPI_H_

/*
 * Error codes.
 */
enum {  MICROD_HOSTNAME_ERROR = 100,
	MICROD_SOCKET_ERROR,
	MICROD_CONNECT_ERROR,
	MICROD_READ_ERROR,
	MICROD_TYPE_ERROR,
	MICROD_SSLCTX_ERROR,
	MICROD_SSLCERT_ERROR,
	MICROD_SSLKEY_ERROR,
	MICROD_SSLVERIFY_ERROR,
	MICROD_SSLNOTINIT_ERROR,
	MICROD_SSLALLOC_ERROR
};

/*
 * Prototypes.
 */
int FindIpAddr( char *HostName, unsigned long *IpAddr );
int SendDriftAndOffset( unsigned long IpAddr, int Offset, int Drift );
int SendFreqDriftAndOffset( unsigned long IpAddr, int Offset,
			    int Drift, int FreqDrift );
int InitSsl( char *CertFile, char *KeyFile, char *CaFile, char *Cipher );
int SslSendDriftAndOffset( unsigned long IpAddr, int Offset, int Drift );
int SslSendFreqDriftAndOffset( unsigned long IpAddr, int Offset,
			       int Drift, int FreqDrift );

#endif  /* _MICROAPI_H_ */
