/*
 * File : apitest.c
 *
 * Date : 991127
 */

#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <unistd.h>
#include <string.h>
#include <sys/types.h>
#include "microapi.h"

void Usage( char *Prog )
{

  printf( "Usage: %s ssl/nossl hostname offset drift\n", Prog );
  exit( 1 );

}


/*
 * Main entrypoint.
 */
int main(argc, argv)
  int argc;
  char *argv[];
{
  int Offset, Drift, Ecode, UseSsl = 0;
  unsigned long IpAddr;
  char HostName[ 128 ];

  if( argc < 5 ) {
    Usage( argv[ 0 ] );
  }
  if( strcasecmp( argv[ 1 ], "ssl" ) == 0 )
    UseSsl = 1;
  else if( strcasecmp( argv[ 1 ], "nossl" ) == 0 )
    UseSsl = 0;
  else
    Usage( argv[ 0 ] );

  if( sscanf( argv[ 2 ], "%s", HostName ) != 1 ) {
    Usage( argv[ 0 ] );
  }
  if( sscanf( argv[ 3 ], "%d", &Offset ) != 1 ) {
    Usage( argv[ 0 ] );
  }
  if( sscanf( argv[ 4 ], "%d", &Drift ) != 1 ) {
    Usage( argv[ 0 ] );
  }
  if( FindIpAddr( HostName, &IpAddr ) != 0 ) {
    printf( "Can't resolve server hostname %s\n", HostName );
    exit( 1 );
  }
  if( UseSsl ) {
    if( ( Ecode = InitSsl( NULL, NULL, NULL, NULL ) ) != 0 ) {
      printf( "Error code %d returned by Initssl()\n", Ecode );
      exit( 1 );
    }
    while( 1 ) {
      if( ( Ecode = SslSendFreqDriftAndOffset( IpAddr, Offset, Drift, 10 ) ) != 0 ) {
        printf( "Error %d when trying to send to %s\n", Ecode, HostName );
        exit( 1 );
      }
      sleep( 30 );
      if( ( Ecode = SslSendDriftAndOffset( IpAddr, 0, 0 ) ) != 0 ) {
        printf( "Error %d when trying to send to %s\n", Ecode, HostName );
        exit( 1 );
      }
      sleep( 30 );
    }
  }
  else {
    while( 1 ) {
      if( ( Ecode = SendDriftAndOffset( IpAddr, Offset, Drift ) ) != 0 ) {
        printf( "Error %d when trying to send to %s\n", Ecode, HostName );
        exit( 1 );
      }
      sleep( 30 );
      if( ( Ecode = SendDriftAndOffset( IpAddr, 0, 0 ) ) != 0 ) {
        printf( "Error %d when trying to send to %s\n", Ecode, HostName );
        exit( 1 );
      }
      sleep( 30 );
    }
  }
  return 0;
}
