/*
 * authreadkeys.c - routines to support the reading of the key file
 */

#include <stdio.h>
#include <stdlib.h>
#include <syslog.h>
#include <signal.h>
#include <errno.h>
#include <unistd.h>
#include <string.h>

#include <sys/types.h>
#include <sys/time.h>
#include <sys/socket.h>
#include <sys/ioctl.h>
#include <sys/file.h>

#include <net/if.h>

#include <openssl/rsa.h>
#include <openssl/crypto.h>
#include <openssl/x509.h>
#include <openssl/pem.h>
#include <openssl/ssl.h>
#include <openssl/err.h>
#include <openssl/e_os.h>
#include <openssl/buffer.h>
#include <openssl/bio.h>

#include "ppsclock.h"
#include "microd.h"

#define MD5
#if 0
#define DES
#endif

#if 0
/*
 * Maximum number of packets in rcv queue.
 */
#define MAX_KEY_LENGTH 8

/*
 * Structure to hold a MD5 key.
 */
struct NtpKey {
        struct NtpKey   *next;
        u_long          KeyId;          /* Key id in ntp packets. */
        int             KeyType;        /* Key type defined below. */
        int             KeyLength;      /* Length of key. */
        u_char          Key[ MAX_KEY_LENGTH + 1 ];
};
#endif

/*
 * nexttok - basic internal tokenizing routine
 */
static char *nexttok( char **str )
{
  register char *cp;
  char *starttok;

  cp = *str;

  /*
   * Space past white space
   */
  while (*cp == ' ' || *cp == '\t')
    cp++;

  /*
   * Save this and space to end of token
   */
  starttok = cp;
  while (*cp != '\0' && *cp != '\n' && *cp != ' ' && *cp != '\t' && *cp != '#')
    cp++;

  /*
   * If token length is zero return an error, else set end of
   * token to zero and return start.
   */
  if (starttok == cp)
    return 0;

  if (*cp == ' ' || *cp == '\t')
    *cp++ = '\0';
  else
    *cp = '\0';

  *str = cp;
  return starttok;
}

/*
 * Insert a key into the linked list of key structs.
 */
static int InsertNewKey( u_long KeyNo, int KeyType, char *Token )
{
  struct NtpKey *Key;
  int i, tmp;
  u_char *cpnt, string[ 3 ];

  if( ( Key = (struct NtpKey *)
	      (malloc( sizeof( struct NtpKey ) )) ) == NULL )
    return( MEMORY_ERROR );

  Key->next = NtpKeyChain;
  NtpKeyChain = Key;
  Key->KeyId = KeyNo;
  Key->KeyType = KeyType;
  bzero( Key->Key, sizeof Key->Key );
  switch( KeyType ) {
    case KEY_TYPE_MD5 :
      strncpy( Key->Key, Token, sizeof Key->Key - 1 );
      Key->KeyLength = strlen( Key->Key );
      break;

    case KEY_TYPE_ASCII :
      strncpy( Key->Key, Token, sizeof Key->Key - 1 );
      Key->KeyLength = 8;
      break;

    case KEY_TYPE_NTP :
    case KEY_TYPE_STD :
      cpnt = (u_char *)(Key->Key);
      for( i=0; i<8; i++ ) {
	string[ 0 ] = *Token++;
	string[ 1 ] = *Token++;
	string[ 2 ] = '\0';
	sscanf( string, "%x", &tmp );
	Key->Key[ i ] = (u_char)(tmp);
      }
      Key->KeyLength = 8;
      break;

    default :
      return( UNKNOWN_KEY_TYPE );

  }
  nNtpKeys++;
  return( 0 );

}

/*
 * authreadkeys - (re)read keys from a file.
 */
int AuthReadKeys( file )
  char *file;
{
  FILE *fp;
  char *line, *token;
  u_long keyno;
  int keytype, ECode;
  char buf[512];		/* lots of room for line? */

	/*
	 * Open file.  Complain and return if it can't be opened.
	 */
	fp = fopen(file, "r");
	if (fp == NULL) {
		printf("can't open key file %s", file);
		return( NO_KEY_FILE );
	}
	/*
	 * Now read lines from the file, looking for key entries
	 */
	while ((line = fgets(buf, sizeof buf, fp)) != NULL) {
		token = nexttok(&line);
		if (token == 0)
			continue;

		/*
		 * First is key number.  See if it is okay.
		 */
		keyno = atoi(token);
		if (keyno == 0) {
			printf("cannot use keyid 0, entry `%s' ignored\n",
				token);
			continue;
		}

		/*
		 * Next is keytype.  See if that is all right.
		 */
		token = nexttok(&line);
		if (token == 0) {
			printf("no key type for key number %ld, entry ignored\n",
			    keyno);
			continue;
		}
		switch (*token) {
#ifdef	DES
		case 'S':
		case 's':
		    keytype = KEY_TYPE_STD; break;

		case 'N':
		case 'n':
		    keytype = KEY_TYPE_NTP; break;

		case 'A':
		case 'a':
		    keytype = KEY_TYPE_ASCII; break;
#endif
#ifdef	MD5
		case 'M':
		case 'm':
		    keytype = KEY_TYPE_MD5; break;
#endif
		default:
		   printf("invalid key type for key number %ld, entry ignored\n",
			   keyno);
		    continue;
		}

		/*
		 * Finally, get key and insert it
		 */
		token = nexttok(&line);
		if (token == 0) {
			printf("no key for number %ld entry, entry ignored\n",
			       keyno);
		} else {
		    switch(keytype) {
#ifdef	DES
		    case KEY_TYPE_STD:
		    case KEY_TYPE_NTP:
		    case KEY_TYPE_ASCII:
			if((ECode = InsertNewKey(keyno, keytype, token)) != 0 ) {
			    printf( "Can't insert key %ld\n", keyno );
			    return( ECode );
			}
			break;
#endif
#ifdef	MD5
		    case KEY_TYPE_MD5:
			if((ECode = InsertNewKey(keyno, keytype, token)) != 0 ) {
			    printf( "Can't insert key %ld\n", keyno );
			    return( ECode );
			}
			break;
#endif
		    }
		}
	}
	(void) fclose(fp);
	return( 0 );
}
