/*
 *  md5crypt - MD5 based authentication routines
 */

#include <string.h>
#include <sys/types.h>
#include "md5_types.h"
#include "md5_string.h"
#include "md5.h"

/*
 * For our purposes an NTP packet looks like:
 *
 *	a variable amount of encrypted data, multiple of 8 bytes, followed by:
 *	NOCRYPT_OCTETS worth of unencrypted data, followed by:
 *	BLOCK_OCTETS worth of ciphered checksum.
 */
#define	NOCRYPT_OCTETS	4
#define	BLOCK_OCTETS	16

#define	NOCRYPT_LONGS	((NOCRYPT_OCTETS)/sizeof(U_LONG))
#define	BLOCK_LONGS	((BLOCK_OCTETS)/sizeof(U_LONG))


/*
 *  Do first stage of a two stage authenticator generation.
 */

int MD5authcrypt( key, keylen, pkt, length, cksm )
  u_char *key;
  int keylen;
  u_long *pkt;
  int length;	/* length of all encrypted data */
  u_char *cksm;
{
  MD5_CTX ctx;
#if 0
  u_char *ctxpnt;
  int i;
#endif

  MD5Init( &ctx );
  MD5Update( &ctx, key, keylen );
  MD5Update( &ctx, (char *)pkt, length );
  MD5Final( &ctx );

  memmove( (char *)(cksm), (char *)(ctx.digest), BLOCK_OCTETS );
#if 0
  ctxpnt = (u_char *)(ctx.digest);
  for( i = 0; i < BLOCK_OCTETS; i++ ) {
    if( *cksm++ != *ctxpnt++ )
      return( 1 );
  }
#endif
  return( 0 );

}
