#include <stdio.h>
#include <stdlib.h>
#include <syslog.h>
#include <signal.h>
#include <errno.h>
#include <unistd.h>
#include <string.h>

#include <sys/types.h>
#include <sys/time.h>
#include <sys/socket.h>
#include <sys/ioctl.h>
#include <sys/file.h>

#include <net/if.h>
#include <netinet/in.h>
#include <netinet/in_systm.h>
#include <netinet/ip.h>
#include <netinet/in.h>
#include <netinet/udp.h>
#include <netinet/tcp.h>
#include <netinet/ip_icmp.h>
#include <arpa/inet.h>

#include "checkntp.h"

int main( int argc, char *argv[] )
{
  int i, Modes, Sock;
  struct NtpCnt cBuf;

  for( i = 0; i < 8; i++ )
    cBuf.Counter[ i ] = -1;

  Sock = socket(AF_INET, SOCK_DGRAM, 0);
  if( argc > 1 && sscanf( argv[ 1 ], "%d", &Modes ) == 1 ) {
    if( Sock < 0 ) {
      printf( "Can't create socket for ioctl's" );
      exit( 1 );
    }
    if( Modes >= 0 ) {
      if( ioctl( Sock, SIOCIP_NTPALLOWMODE, (caddr_t)(&Modes) ) < 0 ) {
	printf( "Error calling ioctl\n" );
	exit( 1 );
      }
    }
    else {
      Modes = -Modes;
      if( ioctl( Sock, SIOCIP_NTPDISALLOWMODE, (caddr_t)(&Modes) ) < 0 ) {
	printf( "Error calling ioctl\n" );
	exit( 1 );
      }
    }
  }
  if( ioctl( Sock, SIOCIP_NTPREADMODE, (caddr_t)(&Modes) ) < 0 ) {
    printf( "Error calling ioctl\n" );
    exit( 1 );
  }
  if( ioctl( Sock, SIOCIP_NTPREADCOUNTERS, (caddr_t)(&cBuf) ) < 0 ) {
    printf( "Error calling ioctl\n" );
    exit( 1 );
  }
  printf( "Ntp modes :\n" );
  for( i = 0; i < 8; i = i++ ) {
    printf( "  Mode %d: %s   Count: %u\n",
	    i, Modes & 0x01 ? "Allowed    " : "Not allowed", cBuf.Counter[i] );
    Modes = Modes >> 1;
  }
  return 0;
}
