#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <ntp_fp.h>
#include <ntp.h>
#include <ntp_request.h>
#include <ntp_stdlib.h>
#include <lib_strbuf.h>
#include <ntp_string.h>
#include <ntp_unixtime.h>

#include <openssl/rsa.h>
#include <openssl/crypto.h>
#include <openssl/x509.h>
#include <openssl/pem.h>
#include <openssl/ssl.h>
#include <openssl/err.h>
#include <openssl/e_os.h>
#include <openssl/buffer.h>
#include <openssl/bio.h>

#include "ppsclock.h"

#define DEFINE_GLOBALS
#include "microd.h"

extern u_long ustotslo[256];
extern u_long ustotsmid[256];
extern u_long ustotshi[16];

struct fltab { u_char	flag;
	       char	*text;
};

struct fltab2 { u_short	flag;
		char	*text;
};

struct fltab2 RestrMFlags[] =
{
  { RESM_INTERFACE, "INTERFACE" },
  { RESM_NTPONLY, "NTPONLY" }
};

struct fltab2 RestrFlags[] =
{
  { RES_IGNORE, "IGNORE" },
  { RES_DONTSERVE, "DONTSERVE" },
  { RES_DONTTRUST, "DONTTRUST" },
  { RES_NOQUERY, "NOQUERY" },
  { RES_NOMODIFY, "NOMODIFY" },
  { RES_NOPEER, "NOPEER" },
  { RES_NOTRAP, "NOTRAP" },
  { RES_LPTRAP, "LPTRAP" },
  { RES_LIMITED, "LIMITED" }
};

struct fltab PeerFlags[] =
{
  { INFO_FLAG_CONFIG, "CONFIG" },
  { INFO_FLAG_SYSPEER, "SYSPEER" },
  { INFO_FLAG_UNUSED, "UNUSED" },
  { INFO_FLAG_REFCLOCK, "REFCLOCK" },
  { INFO_FLAG_PREFER, "PREFER" },
  { INFO_FLAG_AUTHENABLE, "AUTHENABLE" },
  { INFO_FLAG_SEL_CANDIDATE, "SEL_CANDIDATE" },
  { INFO_FLAG_SHORTLIST, "SHORTLIST" }
};

void
ntp_memset(a, x, c)
        char *a;
        int x, c;
{
        while (c-- > 0)
                *a++ = x;
}

/*
 * Storage declarations
 */
char lib_stringbuf[LIB_NUMBUFS][LIB_BUFLENGTH];
int lib_nextbuf;


/*
 * initialization routine.  Might be needed if the code is ROMized.
 */
void
init_lib()
{
	lib_nextbuf = 0;
}

/*
 * dolfptoa - do the grunge work of converting an l_fp number to decimal
 */

char *
dolfptoa(fpi, fpv, neg, ndec, msec)
	u_long fpi;
	u_long fpv;
	int neg;
	int ndec;
	int msec;
{
	register u_char *cp, *cpend;
	register u_long lwork;
	register int dec;
	u_char cbuf[24];
	u_char *cpdec;
	char *buf;
	char *bp;

	/*
	 * Get a string buffer before starting
	 */
	LIB_GETBUF(buf);

	/*
	 * Zero the character buffer
	 */
	memset((char *) cbuf, 0, sizeof(cbuf));

	/*
	 * Work on the integral part.  This is biased by what I know
	 * compiles fairly well for a 68000.
	 */
	cp = cpend = &cbuf[10];
	lwork = fpi;
	if (lwork & 0xffff0000) {
		register u_long lten = 10;
		register u_long ltmp;

		do {
			ltmp = lwork;
			lwork /= lten;
			ltmp -= (lwork << 3) + (lwork << 1);
			*--cp = (u_char)ltmp;
		} while (lwork & 0xffff0000);
	}
	if (lwork != 0) {
		register u_short sten = 10;
		register u_short stmp;
		register u_short swork = (u_short)lwork;

		do {
			stmp = swork;
			swork /= sten;
			stmp -= (swork<<3) + (swork<<1);
			*--cp = (u_char)stmp;
		} while (swork != 0);
	}

	/*
	 * Done that, now deal with the problem of the fraction.  First
	 * determine the number of decimal places.
	 */
	if (msec) {
		dec = ndec + 3;
		if (dec < 3)
			dec = 3;
		cpdec = &cbuf[13];
	} else {
		dec = ndec;
		if (dec < 0)
			dec = 0;
		cpdec = &cbuf[10];
	}
	if (dec > 12)
		dec = 12;

	/*
	 * If there's a fraction to deal with, do so.
	 */
	if (fpv != 0) {
		l_fp work;

		work.l_ui = 0;
		work.l_uf = fpv;
		while (dec > 0) {
			l_fp ftmp;

			dec--;
			/*
			 * The scheme here is to multiply the
			 * fraction (0.1234...) by ten.  This moves
			 * a junk of BCD into the units part.
			 * record that and iterate.
			 */
			work.l_ui = 0;
			L_LSHIFT(&work);
			ftmp = work;
			L_LSHIFT(&work);
			L_LSHIFT(&work);
			L_ADD(&work, &ftmp);
			*cpend++ = (u_char)work.l_ui;
			if (work.l_uf == 0)
				break;
		}

		/*
		 * Rounding is rotten
		 */
		if (work.l_uf & 0x80000000) {
			register u_char *tp = cpend;

			*(--tp) += 1;
			while (*tp >= 10) {
				*tp = 0;
				*(--tp) += 1;
			};
			if (tp < cp)
				cp = tp;
		}
	}
	cpend += dec;


	/*
	 * We've now got the fraction in cbuf[], with cp pointing at
	 * the first character, cpend pointing past the last, and
	 * cpdec pointing at the first character past the decimal.
	 * Remove leading zeros, then format the number into the
	 * buffer.
	 */
	while (cp < cpdec) {
		if (*cp != 0)
			break;
		cp++;
	}
	if (cp == cpdec)
		--cp;

	bp = buf;
	if (neg)
		*bp++ = '-';
	while (cp < cpend) {
		if (cp == cpdec)
			*bp++ = '.';
		*bp++ = (char)(*cp++ + '0');	/* ascii dependent? */
	}
	*bp = '\0';

	/*
	 * Done!
	 */
	return buf;
}

/*
 * mfptoa - Return an asciized representation of a signed long fp number
 */

char *
mfptoa(fpi, fpf, ndec)
	u_long fpi;
	u_long fpf;
	int ndec;
{
	int isneg;

	if (M_ISNEG(fpi, fpf)) {
		isneg = 1;
		M_NEG(fpi, fpf);
	} else
		isneg = 0;

	return dolfptoa(fpi, fpf, isneg, ndec, 0);
}

/*
 * dofptoa - do the grunge work to convert an fp number to ascii
 */

char *
dofptoa(fpv, neg, ndec, msec)
	u_fp fpv;
	int neg;
	int ndec;
	int msec;
{
	register u_char *cp, *cpend;
	register u_long val;
	register short dec;
	u_char cbuf[12];
	u_char *cpdec;
	char *buf;
	char *bp;

	/*
	 * Get a string buffer before starting
	 */
	LIB_GETBUF(buf);

	/*
	 * Zero out the buffer
	 */
	memset((char *)cbuf, 0, sizeof cbuf);

	/*
	 * Set the pointers to point at the first
	 * decimal place.  Get a local copy of the value.
	 */
	cp = cpend = &cbuf[5];
	val = fpv;

	/*
	 * If we have to, decode the integral part
	 */
	if (!(val & 0xffff0000))
		cp--;
	else {
		register u_short sv = (u_short)(val >> 16);
		register u_short tmp;
		register u_short ten = 10;

		do {
			tmp = sv;
			sv /= ten;
			*(--cp) = tmp - ((sv<<3) + (sv<<1));
		} while (sv != 0);
	}

	/*
	 * Figure out how much of the fraction to do
	 */
	if (msec) {
		dec = ndec + 3;
		if (dec < 3)
			dec = 3;
		cpdec = &cbuf[8];
	} else {
		dec = ndec;
		cpdec = cpend;
	}

	if (dec > 6)
		dec = 6;

	if (dec > 0) {
		do {
			val &= 0xffff;
			val = (val << 3) + (val << 1);
			*cpend++ = (u_char)(val >> 16);
		} while (--dec > 0);
	}

	if (val & 0x8000) {
		register u_char *tp;
		/*
		 * Round it. Ick.
		 */
		tp = cpend;
		*(--tp) += 1;
		while (*tp >= 10) {
			*tp = 0;
			*(--tp) += 1;
		}
	}

	/*
	 * Remove leading zeroes if necessary
	 */
	while (cp < (cpdec -1) && *cp == 0)
		cp++;

	/*
	 * Copy it into the buffer, asciizing as we go.
	 */
	bp = buf;
	if (neg)
		*bp++ = '-';

	while (cp < cpend) {
		if (cp == cpdec)
			*bp++ = '.';
		*bp++ = (char)(*cp++ + '0');
	}
	*bp = '\0';
	return buf;
}


/*
 * fptoa - return an asciized representation of an s_fp number
 */

char *
fptoa(fpv, ndec)
        s_fp fpv;
        int ndec;
{
        u_fp plusfp;
        int neg;

        if (fpv < 0) {
                plusfp = (u_fp)(-fpv);
                neg = 1;
        } else {
                plusfp = (u_fp)fpv;
                neg = 0;
        }

        return dofptoa(plusfp, neg, ndec, 0);
}


/*
 * gettstamp - return the system time in timestamp format
 */
void gettstamp(ts)
	l_fp *ts;
{
	struct timeval tv;

	/*
	 * Quickly get the time of day and convert it
	 */
	(void) GETTIMEOFDAY(&tv, (struct timezone *)NULL);
	if (tv.tv_usec >= 1000000) {	/* bum solaris */
		tv.tv_usec -= 1000000;
		tv.tv_sec++;
	}
	TVTOTS(&tv, ts);
	ts->l_uf += TS_ROUNDBIT;	/* guaranteed not to overflow */
	ts->l_ui += JAN_1970;
	ts->l_uf &= TS_MASK;
}


/*
 * Search for a MD5 key in the linked list of
 * key structs.
 */
struct NtpKey *FindNtpKey( KeyId )
  u_long KeyId;
{

  struct NtpKey *Key;

  for( Key = NtpKeyChain; Key != NULL; Key = Key->next ) {
    if( Key->KeyId == KeyId )
      return( Key );
  }
  return( NULL );

}

int main( int argc, char *argv[] )
{
  fd_set Fds;
  struct sockaddr_in LocSa, Sa;
  int Sock, i, j, Length;
  struct timeval tmvl;
  struct NtpKey *Key;
  struct hostent *Host;
  struct req_pkt *NtpPkt;
  struct info_loop *NtpLoop;
  struct info_peer_summary *NtpSum;
  struct info_restrict *NtpInfoRestrict;
  struct conf_restrict *NtpRestrict;
  l_fp tempts;
  unsigned char InputBuffer[ 1024 ];


  if( AuthReadKeys( "/etc/ntp.keys" ) != 0 ) {
    printf( "Can't read md5 keys\n" );
    exit( 1 );
  }
  if( argc < 2 ) {
    printf( "usage: %s hostname\n", argv[ 0 ] );
    exit( 1 );
  }
  if( ( Host = gethostbyname( argv[ 1 ] ) ) == NULL ) {
    printf( "host %s is unknown\n", argv[ 1 ] );
    exit( 1 );
  }
  /*
   * Create socket.
   */
  Sock = socket(AF_INET, SOCK_DGRAM, 0);
  if( Sock < 0 ) {
    printf( "Can't create socket, errno : %d", errno );
    exit( 1 );
  }
  bzero( &LocSa, sizeof LocSa );
  LocSa.sin_len = sizeof( struct sockaddr_in );
  LocSa.sin_family = AF_INET;
  LocSa.sin_addr.s_addr = INADDR_ANY;
  LocSa.sin_port =  0;
  if( bind( Sock, (struct sockaddr *)(&LocSa), sizeof LocSa ) < 0 ) {
    printf( "Can't bind socket, errno : %d", errno );
    close( Sock );
    exit( 1 );
  }

  bzero( &Sa, sizeof Sa );
  Sa.sin_len = sizeof( struct sockaddr_in );
  Sa.sin_family = AF_INET;
  Sa.sin_addr.s_addr = *((u_int32_t *)(Host->h_addr_list[ 0 ]));
  Sa.sin_port =  htons( 123 );

  bzero( InputBuffer, sizeof InputBuffer );
  NtpPkt = (struct req_pkt *)(InputBuffer);
  NtpPkt->rm_vn_mode = RM_VN_MODE( 0, 0 );
  NtpPkt->auth_seq = AUTH_SEQ( 0, 0 );
  NtpPkt->implementation = IMPL_XNTPD;
  NtpPkt->request = REQ_PEER_LIST_SUM;
  NtpPkt->err_nitems = ERR_NITEMS( 0, 0 );
  NtpPkt->mbz_itemsize = MBZ_ITEMSIZE( 0 );
  if( sendto( Sock, InputBuffer, REQ_LEN_NOMAC, 0,
	      (struct sockaddr *)(&Sa), sizeof Sa ) != REQ_LEN_NOMAC ) {
    printf( "Can't send request, errno : %d", errno );
    exit( 1 );
  }

  FD_ZERO( &Fds );
  FD_SET( Sock, &Fds );
  if( ( i = select( FD_SETSIZE, &Fds, NULL, NULL, NULL ) ) < 0 ) {
    printf( "select failed with errno : %d", errno );
    exit( 1 );
  }
  if( FD_ISSET( Sock, &Fds ) ) {
    /*
     * Answer received.
     */
    i = sizeof Sa;
    bzero( InputBuffer, sizeof InputBuffer );
    Length = recvfrom( Sock, InputBuffer, sizeof InputBuffer, 0,
		       (struct sockaddr *)(&Sa), &i );
    if( Length < 0 ) {
      printf( "recvfrom failed with errno : %d", errno );
      exit( 1 );
    }
    printf( "%d bytes received\n", Length );
    for( i = 0; i < Length; i++ )
      if( i < 8 )
	printf( "%02x ", InputBuffer[ i ] );
      else
	printf( "%d ", InputBuffer[ i ] );

    printf( "\n" );

#if 1
    NtpSum = (struct info_peer_summary *)(NtpPkt->data);
#else
    NtpInfoRestrict = (struct info_restrict *)(NtpPkt->data);
#endif
    printf( "nItems %d\n", INFO_NITEMS( NtpPkt->err_nitems) );
    for( i = 0; i < INFO_NITEMS( NtpPkt->err_nitems); i++ ) {
#if 0
      printf( "Item no : %d\n", i + 1 );
      printf( "Addr : %s\n",
	      inet_ntoa( *((struct in_addr *)(&NtpInfoRestrict->addr)) ) );
      printf( "Mask : %s\n",
	      inet_ntoa( *((struct in_addr *)(&NtpInfoRestrict->mask)) ) );
      printf( "Count : %ld\n", ntohl( NtpInfoRestrict->count ) );
      printf( "Flags : " );
      for( j = 0; j < ( sizeof RestrFlags / sizeof RestrFlags[ 0 ] ); j++ ) {
	if( ntohs( NtpInfoRestrict->flags ) & RestrFlags[ j ].flag )
	  printf( "%s ", RestrFlags[ j ].text );
      }
      printf( "\n" );
      printf( "mFlags : " );
      for( j = 0; j < ( sizeof RestrMFlags / sizeof RestrMFlags[ 0 ] ); j++ ) {
	if( ntohs( NtpInfoRestrict->mflags ) & RestrMFlags[ j ].flag )
	  printf( "%s ", RestrMFlags[ j ].text );
      }
      printf( "\n" );
      NtpInfoRestrict++;
#else
      printf( "Item no : %d\n", i + 1 );
      printf( "Local addr : %s\n",
	      inet_ntoa( *((struct in_addr *)(&NtpSum->dstadr)) ) );
      printf( "Remote addr : %s\n",
	      inet_ntoa( *((struct in_addr *)(&NtpSum->srcadr)) ) );
      printf( "Remote port : %d\n", ntohs( NtpSum->srcport ) );
      printf( "Stratum : %d\n", NtpSum->stratum );
      printf( "Hpoll : %d\n", NtpSum->hpoll );
      printf( "Ppoll : %d\n", NtpSum->ppoll );
      printf( "Reach : %02x\n", NtpSum->reach );
      printf( "Flags : " );
      for( j = 0; j < ( sizeof PeerFlags / sizeof PeerFlags[ 0 ] ); j++ ) {
	if( NtpSum->flags & PeerFlags[ j ].flag )
	  printf( "%s ", PeerFlags[ j ].text );
      }
      printf( "\n" );
      printf( "Hmode : %d\n", NtpSum->hmode );

      NTOHL_FP( &NtpSum->offset, &tempts );
      printf( "Offset : %-9.9s\n", lfptoa( &tempts, 6 ) );
      printf( "Delay : %s\n", fptoa(NTOHS_FP(NtpSum->delay), 5) );
      printf( "Dispersion : %s\n", ufptoa(NTOHS_FP(NtpSum->dispersion), 5) );
      NtpSum++;
#endif
    }
  }
  else {
    printf( "Select returns without data\n" );
  }
  return 0;
}
