#include <stdio.h>
#include <stdlib.h>
#include <syslog.h>
#include <signal.h>
#include <errno.h>
#include <unistd.h>
#include <string.h>

#include <sys/types.h>
#include <sys/time.h>
#include <sys/socket.h>
#include <sys/ioctl.h>
#include <sys/file.h>

#include <net/if.h>
#include <netinet/in.h>
#include <netinet/in_systm.h>
#include <netinet/ip.h>
#include <netinet/in.h>
#include <netinet/udp.h>
#include <netinet/tcp.h>
#include <netinet/ip_icmp.h>
#include <arpa/inet.h>
#include <netdb.h>

#include <openssl/rsa.h>
#include <openssl/crypto.h>
#include <openssl/x509.h>
#include <openssl/pem.h>
#include <openssl/ssl.h>
#include <openssl/err.h>
#include <openssl/e_os.h>
#include <openssl/buffer.h>
#include <openssl/bio.h>



int main( int argc, char *argv[] )
{
  char* certfile="/etc/certificate/Zoo.Everyware.SE_cert.pem";
  char* keyfile="/etc/certificate/Zoo.Everyware.SE_key.pem";
  char* cafile="/etc/certificate/cacert.pem";
  SSL_CTX* ctx;
  SSL_METHOD *meth;
  SSL *ssl;
  int Sock;
  struct sockaddr_in Sa;
  struct hostent *Host;
  char HostName[ 128 ];


    SSL_load_error_strings();
    SSLeay_add_ssl_algorithms();
    meth = SSLv23_client_method();
    ctx = SSL_CTX_new (meth);

    if (!ctx) {
      syslog(LOG_ERR, "SSL_CTX_NEW: %s", ERR_error_string(ERR_get_error(), NULL));
      exit(2);
    }
    SSL_CTX_set_options(ctx,0);
    if (SSL_CTX_use_certificate_file(ctx, certfile, SSL_FILETYPE_PEM) <= 0) {
      ERR_print_errors_fp(stderr);
      exit(3);
    }
    if (SSL_CTX_use_PrivateKey_file(ctx, keyfile, SSL_FILETYPE_PEM) <= 0) {
      ERR_print_errors_fp(stderr);
      exit(4);
    }
    if ((!SSL_CTX_load_verify_locations(ctx,cafile,NULL)) ||
        (!SSL_CTX_set_default_verify_paths(ctx)))
      {
        ERR_print_errors_fp(stderr);
        exit(6);
      }
    ssl = SSL_new( ctx );


  if( argc < 2 ) {
    printf( "Syntax error\n" );
    exit( 1 );
  }
  if( sscanf( argv[ 1 ], "%s", HostName ) != 1 ) {
    printf( "Syntax error\n" );
    exit( 1 );
  }
  if( ( Host = gethostbyname( HostName ) ) == NULL ) {
    printf( "Can't resolve server hostname %s", HostName );
    exit( 1 );
  }
  /*
   * Create a socket for client connections.
   */
  Sock = socket(AF_INET, SOCK_STREAM, 0);
  if (Sock < 0) {
    printf( "Can't create socket, errno : %d\n", errno );
    exit(1);
  }
  bzero( &Sa, sizeof Sa );
  Sa.sin_family = AF_INET;
  Sa.sin_port =  htons( 4711 );
  Sa.sin_addr.s_addr = *((u_long *)(Host->h_addr));
  if( connect( Sock, (struct sockaddr *)(&Sa), sizeof(Sa) ) < 0 ) {
    printf( "Can't connect to server" );
    close( Sock );
    exit(1);
  }
  SSL_set_fd( ssl, Sock );
  SSL_connect( ssl );
  printf( "We are connected\n" );
  SSL_write( ssl, "Hej hopp ditt feta nylle\n", 25 );
  printf( "Data written\n" );
  SSL_shutdown( ssl );
  shutdown( SSL_get_fd( ssl ), 2 );
  if( ssl != NULL )
    SSL_free( ssl );

  if( ctx != NULL )
    SSL_CTX_free( ctx );

  return 0;

}
