#include <stdio.h>
#include <stdlib.h>
#include <syslog.h>
#include <signal.h>
#include <errno.h>
#include <unistd.h>
#include <string.h>

#include <sys/types.h>
#include <sys/time.h>
#include <sys/socket.h>
#include <sys/ioctl.h>
#include <sys/file.h>

#include <net/if.h>
#include <netinet/in.h>
#include <netinet/in_systm.h>
#include <netinet/ip.h>
#include <netinet/in.h>
#include <netinet/udp.h>
#include <netinet/tcp.h>
#include <netinet/ip_icmp.h>
#include <arpa/inet.h>

#include <openssl/rsa.h>
#include <openssl/crypto.h>
#include <openssl/x509.h>
#include <openssl/pem.h>
#include <openssl/ssl.h>
#include <openssl/err.h>
#include <openssl/e_os.h>
#include <openssl/buffer.h>
#include <openssl/bio.h>

#define USE_SSL

#ifdef USE_SSL
int verify_callback(int ok, X509_STORE_CTX *ctx)
{
  char buf[256];
  X509 *err_cert;
  int err,depth;

  printf( "verify_callback() called\n" );
  err_cert = X509_STORE_CTX_get_current_cert(ctx);
  err = X509_STORE_CTX_get_error(ctx);
  depth = X509_STORE_CTX_get_error_depth(ctx);

  X509_NAME_oneline(X509_get_subject_name(err_cert),buf,256);
#if 0
  //  syslog(LOG_NOTICE,"depth=%d %s",depth,buf);
  //  BIO_printf(bio_err,"depth=%d %s\n",depth,buf);
#endif
  if (!ok)
    {
      syslog(LOG_WARNING,"verify error:num=%d:%s",err,
                 X509_verify_cert_error_string(err));
    }
  /*
  switch (ctx->error)
    {
    case X509_V_ERR_UNABLE_TO_GET_ISSUER_CERT:
      X509_NAME_oneline(X509_get_issuer_name(ctx->current_cert),buf,256);
      BIO_printf(bio_err,"issuer= %s\n",buf);
      break;
    case X509_V_ERR_CERT_NOT_YET_VALID:
    case X509_V_ERR_ERROR_IN_CERT_NOT_BEFORE_FIELD:
      BIO_printf(bio_err,"notBefore=");
      ASN1_TIME_print(bio_err,X509_get_notBefore(ctx->current_cert));
      BIO_printf(bio_err,"\n");
      break;
    case X509_V_ERR_CERT_HAS_EXPIRED:
    case X509_V_ERR_ERROR_IN_CERT_NOT_AFTER_FIELD:
      BIO_printf(bio_err,"notAfter=");
      ASN1_TIME_print(bio_err,X509_get_notAfter(ctx->current_cert));
      BIO_printf(bio_err,"\n");
      break;
    }
  */
  return(ok);
}

static RSA *tmp_rsa_cb(SSL *s, int is_export, int keylength)
{
  static RSA *rsa_tmp=NULL;

  printf( "tmp_rsa_cb() called\n" );
  if (rsa_tmp == NULL)
    rsa_tmp=RSA_generate_key(keylength,RSA_F4,NULL,NULL);

  return(rsa_tmp);
}
#if 0
void apps_ssl_info_callback(SSL *s, int where, int ret)
{
  char *str;
  int w;

  w=where& ~SSL_ST_MASK;

  if (w & SSL_ST_CONNECT) str="SSL_connect";
  else if (w & SSL_ST_ACCEPT) str="SSL_accept";
  else str="undefined";

  if (where & SSL_CB_LOOP)
  {
    BIO_printf(bio_err,"%s:%s\n",str,SSL_state_string_long(s));
  }
  else if (where & SSL_CB_ALERT)
  {
    str=(where & SSL_CB_READ)?"read":"write";
    BIO_printf(bio_err,"SSL3 alert %s:%s:%s\n",
	       str,
               SSL_alert_type_string_long(ret),
               SSL_alert_desc_string_long(ret));
  }
  else if (where & SSL_CB_EXIT)
  {
    if (ret == 0)
      BIO_printf(bio_err,"%s:failed in %s\n",
                 str,SSL_state_string_long(s));
    else if (ret < 0)
    {
      BIO_printf(bio_err,"%s:error in %s\n",
                 str,SSL_state_string_long(s));
    }
  }
}
#endif

#endif /* USE_SSL */


int main( int argc, char *argv[] )
{
#ifdef USE_SSL
    char* certfile="/etc/certificate/Zoo.Everyware.SE_cert.pem";
    char* keyfile="/etc/certificate/Zoo.Everyware.SE_key.pem";
    char* cafile="/etc/certificate/cacert.pem";
    char* auth="RC4-MD5";
    SSL_CTX* ctx;
    SSL_METHOD *meth;
    SSL *ssl;
    static int s_server_session_id_context = 1; /* anything will do */
#endif


  fd_set Fds;
  int Sock, RxSock, SaLen, i, Line;
  int One = 1;
  time_t Now;
  struct sockaddr_in Sa;
  struct timeval tm;
  char Buf[ 1024 ];


#ifdef USE_SSL   /* Initiate SSL */
    SSL_load_error_strings();
    SSLeay_add_ssl_algorithms();
    meth = SSLv23_server_method();
    ctx = SSL_CTX_new (meth);
    SSL_CTX_set_quiet_shutdown(ctx,1);
    SSL_CTX_set_options(ctx,0);
    SSL_CTX_sess_set_cache_size(ctx,8);
    if (!ctx) {
      syslog(LOG_ERR, "SSL_CTX_NEW: %s", ERR_error_string(ERR_get_error(), NULL));
      exit(2);
    }


    if ((!SSL_CTX_load_verify_locations(ctx,cafile,NULL)) ||
        (!SSL_CTX_set_default_verify_paths(ctx)))
      {
        ERR_print_errors_fp(stderr);
        exit(6);
      }

    if (SSL_CTX_use_certificate_file(ctx, certfile, SSL_FILETYPE_PEM) <= 0) {
      ERR_print_errors_fp(stderr);
      exit(3);
    }
    if (SSL_CTX_use_PrivateKey_file(ctx, keyfile, SSL_FILETYPE_PEM) <= 0) {
      ERR_print_errors_fp(stderr);
      exit(4);
    }

    if (!SSL_CTX_check_private_key(ctx)) {
      fprintf(stderr,"Private key does not match the certificate public key\n");
      exit(5);
    }
    SSL_CTX_set_tmp_rsa_callback(ctx, tmp_rsa_cb);

    SSL_CTX_set_cipher_list(ctx, auth);

    SSL_CTX_set_verify(ctx,(SSL_VERIFY_PEER|SSL_VERIFY_FAIL_IF_NO_PEER_CERT|SSL_VERIFY_CLIENT_ONCE),verify_callback);
    SSL_CTX_set_session_id_context(ctx,(void*)&s_server_session_id_context,
                                   sizeof s_server_session_id_context);
    SSL_CTX_set_client_CA_list(ctx,SSL_load_client_CA_file(cafile));


#endif /* USE_SSL */


  /*
   * Create a socket for client connections.
   */
  Sock = socket(AF_INET, SOCK_STREAM, 0);
  if (Sock < 0) {
    printf( "Can't create socket, errno : %d\n", errno );
    exit(1);
  }
  setsockopt( Sock, SOL_SOCKET, SO_REUSEADDR, &One, sizeof One );
  bzero( &Sa, sizeof Sa );
  Sa.sin_len = sizeof( struct sockaddr_in );
  Sa.sin_family = AF_INET;
  Sa.sin_addr.s_addr = INADDR_ANY;
  Sa.sin_port = htons( 4711 );
  if( bind( Sock, (struct sockaddr *)(&Sa), sizeof(Sa) ) < 0 ) {
    printf( "Can't bind socket, errno : %d\n", errno );
    exit(1);
  }
  listen( Sock, 4 );            /* allow a queue of 4 */

while( 1 ) {
  ssl = SSL_new( ctx );

  FD_ZERO( &Fds );
  /*
   * Wait for a connection.
   */
  FD_SET( Sock, &Fds );
  if( ( i = select( FD_SETSIZE, &Fds, NULL, NULL, NULL ) ) < 0 ) {
    printf( "select failed, errno %d\n", errno );
    exit( 1 );
  }
  /*
   * Accept a new connection.
   */
  if( FD_ISSET( Sock, &Fds ) ) {
    SaLen = sizeof Sa;
    RxSock = accept( Sock, (struct sockaddr *)(&Sa), &SaLen );
    if( RxSock < 0 ) {
      printf( "Error returned from accept, errno : %d\n", errno );
    }
    else {
      SSL_set_fd( ssl, RxSock );
      if( SSL_accept( ssl ) <= 0 ) {
        printf( "SSL_accept returns error\n" );
	ERR_print_errors_fp( stderr );
	exit( 1 );
      }
      printf( "Success, we have a ssl connection\n" );
      i = SSL_read( ssl, Buf, sizeof Buf );
      if( i > 0 ) {
	Buf[ i ] = '\0';
	printf( "%d bytes received, %s\n", i, Buf );
      }
      else {
	printf( "Error returned from SSL_read()\n" );
	ERR_print_errors_fp( stderr );
	exit( 1 );
      }
      SSL_set_shutdown( ssl, SSL_SENT_SHUTDOWN | SSL_RECEIVED_SHUTDOWN );
      SSL_shutdown( ssl );
      if( ssl != NULL )
        SSL_free( ssl );

      close( RxSock );
#if 0
      if( ctx != NULL )
        SSL_CTX_free( ctx );
#endif
    }
  }
  else {
    printf( "No fd:s set in select\n" );
  }
}
  return 0;
}
