/*
 * Simple tcp test daemon
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <signal.h>
#include <syslog.h>
#include <varargs.h>
#include <fcntl.h>
#include <unistd.h>
#include <time.h>
#include <signal.h>
#include <errno.h>
#include <math.h>
#include <sys/ioctl.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>



int main( int argc, char *argv[] )
{
  fd_set Fds;
  int Sock, RxSock, SaLen, i, Line;
  int One = 1;
  time_t Now;
  struct sockaddr_in Sa;
  struct timeval tm;
  FILE *fp;
  double Offset, Dispersion;
  char Buf[ 256 ];


  /*
   * Create a socket for client connections.
   */
  Sock = socket(AF_INET, SOCK_STREAM, 0);
  if (Sock < 0) {
    printf( "Can't create socket, errno : %d\n", errno );
    exit(1);
  }
  setsockopt( Sock, SOL_SOCKET, SO_REUSEADDR, &One, sizeof One );
  bzero( &Sa, sizeof Sa );
  Sa.sin_len = sizeof( struct sockaddr_in );
  Sa.sin_family = AF_INET;
  Sa.sin_addr.s_addr = INADDR_ANY;
  Sa.sin_port = htons( 4711 );
  if( bind( Sock, (struct sockaddr *)(&Sa), sizeof(Sa) ) < 0 ) {
    printf( "Can't bind socket, errno : %d\n", errno );
    exit(1);
  }
  listen( Sock, 4 );            /* allow a queue of 4 */

  while( 1 ) {
    tm.tv_sec = 5;
    tm.tv_usec = 0;
    FD_ZERO( &Fds );
    FD_SET( Sock, &Fds );
    if( ( i = select( FD_SETSIZE, &Fds, NULL, NULL, NULL ) ) < 0 ) {
      printf( "select failed\n" );
      exit( 0 );
    }
    printf( "Connection indication from select\n" );
    getchar();
    /*
     * Timeout from select.
     */
    if( i == 0 ) {
      continue;
    }
    /*
     * Accept a new connection.
     */
    if( FD_ISSET( Sock, &Fds ) ) {
      SaLen = sizeof Sa;
      RxSock = accept( Sock, (struct sockaddr *)(&Sa), &SaLen );
      printf( "Connection accepted\n" );
      getchar();
      if( RxSock < 0 ) {
        printf( "Error returned from accept\n" );
      }
      else {
	close( RxSock );
      }
    }
  }
  return 0;
}
