/*
 * File : symc.c
 *
 * Date : 00-02-07
 */

#include <stdio.h>
#include <stdlib.h>
#include <signal.h>
#include <errno.h>
#include <unistd.h>
#include <string.h>
#include <syslog.h>
#include <time.h>
#include <ctype.h>
#include <netdb.h>

#include <sys/types.h>
#include <sys/time.h>
#include <sys/socket.h>
#include <sys/ioctl.h>
#include <sys/file.h>

#include <net/if.h>
#include <netinet/in.h>
#include <netinet/in_systm.h>
#include <netinet/ip.h>
#include <netinet/in.h>
#include <netinet/udp.h>
#include <netinet/tcp.h>
#include <netinet/ip_icmp.h>
#include <arpa/inet.h>

#define SYMD_PORT 4711

struct TspPacket { struct timeval	SndTime;
		   struct timeval	RcvTime;
};

void CheckRcvdAnswer( int Sock, struct sockaddr_in *Sa,
		      unsigned char *Packet, int Length, int tStamp )
{
  struct timeval tmvl;
  struct TspPacket *TspPnt;
  int sTime, rTime, i, j;

  gettimeofday( &tmvl, NULL );
  TspPnt = (struct TspPacket *)(Packet);
  i = ntohl( TspPnt->SndTime.tv_usec );
  j = ntohl( TspPnt->RcvTime.tv_usec );
  if( j < i )
    j += 1000000;

  sTime = j - i;
  i = tmvl.tv_usec;
  j = ntohl( TspPnt->RcvTime.tv_usec );
  if( i < j )
    i += 1000000;

  rTime = i - j;
  if( tStamp )
    printf( "%ld %d %d\n", tmvl.tv_sec, sTime, rTime );
  else
    printf( "%d %d\n", sTime, rTime );

  fflush( stdout );

}


int main( int argc, char *argv[] )
{
  int OptErrors, chr;
  fd_set Fds;
  struct sockaddr_in LocSa, Sa;
  int Sock, i, Length;
  int TimeStamp = 0;
  int HostFound = 0;
  int AnswerReceived;
  time_t Interval = 60L;
  time_t Now;
  struct timeval tmvl;
  struct TspPacket *TspPnt;
  struct hostent *Host;
  unsigned short Port = SYMD_PORT;
  unsigned char InputBuffer[ 1024 ];


  /*
   * Check the command line arguments.
   */
  OptErrors = 0;
  while( (chr = getopt( argc, argv, "h:p:s:t" )) != EOF) {
    switch( chr ) {

      /*
       * Host name.
       */
      case 'h':
	if( ( Host = gethostbyname( optarg ) ) == NULL ) {
	  printf( "host %s is unknown\n", optarg );
          OptErrors++;
	}
	HostFound = 1;
        break;

      /*
       * Port number.
       */
      case 'p':
        if( sscanf( optarg, "%d", &i ) != 1 ) {
          printf( "Invalid port number\n" );
          OptErrors++;
        }
	Port = (unsigned short)(i);
        break;

      /*
       * Seconds between log samples.
       */
      case 's':
        if( sscanf( optarg, "%ld", &Interval ) != 1 ) {
          printf( "Invalid interval time value\n" );
          OptErrors++;
        }
        break;

      /*
       * Include timestamps in log file.
       */
      case 't':
	TimeStamp = 1;
        break;

      default:
        OptErrors++;
        break;
    }
  }
  if( OptErrors || !HostFound ) {
    printf( "usage: %s -h hostname [-p port][-s delay][-t]\n", argv[ 0 ] );
    exit( 1 );
  }

  /*
   * Create socket.
   */
  Sock = socket(AF_INET, SOCK_DGRAM, 0);
  if( Sock < 0 ) {
    printf( "Can't create socket, errno : %d", errno );
    exit( 1 );
  }
  bzero( &LocSa, sizeof LocSa );
  LocSa.sin_len = sizeof( struct sockaddr_in );
  LocSa.sin_family = AF_INET;
  LocSa.sin_addr.s_addr = INADDR_ANY;
  LocSa.sin_port =  0;
  if( bind( Sock, (struct sockaddr *)(&LocSa), sizeof LocSa ) < 0 ) {
    printf( "Can't bind socket, errno : %d", errno );
    close( Sock );
    exit( 1 );
  }
  /*
   * Eternal loop.
   */
  while( 1 ) {
    bzero( &Sa, sizeof Sa );
    Sa.sin_len = sizeof( struct sockaddr_in );
    Sa.sin_family = AF_INET;
    Sa.sin_addr.s_addr = *((u_int32_t *)(Host->h_addr_list[ 0 ]));
    Sa.sin_port =  htons( Port );

    gettimeofday( &tmvl, NULL );
    TspPnt = (struct TspPacket *)(InputBuffer);
    TspPnt->SndTime.tv_sec = htonl( tmvl.tv_sec );
    TspPnt->SndTime.tv_usec = htonl( tmvl.tv_usec );
    TspPnt->RcvTime.tv_sec = 0;
    TspPnt->RcvTime.tv_usec = 0;
    if( sendto( Sock, InputBuffer, sizeof( struct TspPacket ), 0,
        (struct sockaddr *)(&Sa), sizeof Sa ) != sizeof( struct TspPacket ) ) {
      printf( "Can't send request, errno : %d", errno );
      exit( 1 );
    }
    Now = (time_t)(tmvl.tv_sec);
    AnswerReceived = 0;
    while( 1 ) {
      FD_ZERO( &Fds );
      FD_SET( Sock, &Fds );
      tmvl.tv_sec = 0;
      tmvl.tv_usec = 200000;
      if( ( i = select( FD_SETSIZE, &Fds, NULL, NULL, &tmvl ) ) < 0 ) {
        printf( "select failed with errno : %d", errno );
        exit( 1 );
      }
      if( FD_ISSET( Sock, &Fds ) ) {
        /*
         * Answer received.
         */
	i = sizeof Sa;
	Length = recvfrom( Sock, InputBuffer, sizeof InputBuffer, 0,
			   (struct sockaddr *)(&Sa), &i );
	if( Length < 0 ) {
          printf( "recvfrom failed with errno : %d", errno );
          continue;
        }
        CheckRcvdAnswer( Sock, &Sa, InputBuffer, Length, TimeStamp );
	AnswerReceived = 1;
      }
      if( time( NULL ) >= Now + Interval ) {
	if( !AnswerReceived )
	  printf( "Packet lost\n" );

	break;
      }
    }


  }
  return 0;
}
