/*
 * File : symd.c
 *
 * Date : 00-02-07
 */

#include <stdio.h>
#include <stdlib.h>
#include <signal.h>
#include <syslog.h>
#include <errno.h>
#include <unistd.h>
#include <string.h>
#include <time.h>
#include <ctype.h>

#include <sys/types.h>
#include <sys/time.h>
#include <sys/socket.h>
#include <sys/ioctl.h>
#include <sys/file.h>

#include <net/if.h>
#include <netinet/in.h>
#include <netinet/in_systm.h>
#include <netinet/ip.h>
#include <netinet/in.h>
#include <netinet/udp.h>
#include <netinet/tcp.h>
#include <netinet/ip_icmp.h>
#include <arpa/inet.h>

#define SYMD_PORT 4711

struct TspPacket { struct timeval	SndTime;
		   struct timeval	RcvTime;
};


/*
 * Terminate the program.
 */
static void Terminate( int sig )
{

  signal(SIGTERM, SIG_DFL);
  exit( 0 );

}


/*
 * Disconnect the tty and enter daemon mode.
 */
static void DisconnectFromTty()
{
  int i;

  if( fork() ) {
    exit(0);
  }
  i = open("/dev/tty", O_RDWR);
  if( i >= 0 ) {
    (void) ioctl(i, TIOCNOTTY, NULL);
    (void) close(i);
  }

}


void CheckRcvdQuery( int Sock, struct sockaddr_in *Sa,
		     unsigned char *Packet, int Length )
{
  struct timeval tmvl;
  struct TspPacket *TspPnt;

  gettimeofday( &tmvl, NULL );
  TspPnt = (struct TspPacket *)(Packet);
  TspPnt->RcvTime.tv_sec = htonl( tmvl.tv_sec );
  TspPnt->RcvTime.tv_usec = htonl( tmvl.tv_usec );
  if( sendto( Sock, Packet, Length, 0,
              (struct sockaddr *)(Sa), sizeof( struct sockaddr ) ) != Length )
    syslog( LOG_ERR, "Can't send answer, %m" );

}


int main( int argc, char *argv[] )
{
  fd_set Fds;
  struct sockaddr_in Sa;
  int on = 1;
  int Sock, i, Length;
  unsigned short Port;
  unsigned char InputBuffer[ 1024 ];


  if( argc > 1 ) {
    if( sscanf( argv[ 1 ], "%d", &i ) != 1 ) {
      printf( "Invalid port number\n" );
      exit( 1 );
    }
    Port = (unsigned short)(i);
  }
  else {
    Port = SYMD_PORT;
  }
  /*
   * Create socket to receive queries.
   */
  Sock = socket(AF_INET, SOCK_DGRAM, 0);
  if( Sock < 0 ) {
    printf( "Can't create socket, errno : %d", errno );
    exit( 1 );
  }
  if( setsockopt( Sock, SOL_SOCKET, SO_REUSEADDR, (char *)(&on),
							sizeof( on ) ) != 0 ) {
    printf( "Can't set socket option, errno : %d", errno );
    exit( 1 );
  }
  /*
   * Bind the socket.
   */
  bzero( &Sa, sizeof Sa );
  Sa.sin_len = sizeof( struct sockaddr_in );
  Sa.sin_family = AF_INET;
  Sa.sin_addr.s_addr = INADDR_ANY;
  Sa.sin_port =  htons( Port );
  if( bind( Sock, (struct sockaddr *)(&Sa), sizeof(Sa) ) < 0 ) {
    printf( "Can't bind socket, errno : %d", errno );
    exit( 1 );
  }
  listen( Sock, 4 );            /* allow a queue of 4 */
  /*
   * Eternal loop. Process received queries.
   */
  (void)signal(SIGTERM, Terminate);
  (void)signal(SIGINT, Terminate);
  (void)signal(SIGQUIT, Terminate);
  openlog( "symd", LOG_PID | LOG_NDELAY, LOG_LOCAL0 );
  syslog( LOG_ERR, "Starting symd on port %d", Port );
  DisconnectFromTty();
  while( 1 ) {
    FD_ZERO( &Fds );
    FD_SET( Sock, &Fds );
    if( ( i = select( FD_SETSIZE, &Fds, NULL, NULL, NULL ) ) < 0 ) {
      printf( "select failed with errno : %d", errno );
      continue;
    }
    if( FD_ISSET( Sock, &Fds ) ) {
      /*
       * Query received.
       */
      i = sizeof Sa;
      Length = recvfrom( Sock, InputBuffer, sizeof InputBuffer, 0,
		         (struct sockaddr *)(&Sa), &i );
      if( Length < 0 ) {
        printf( "recvfrom failed with errno : %d", errno );
        continue;
      }
      CheckRcvdQuery( Sock, &Sa, InputBuffer, Length );
    }
  }
  return 0;
}
