#include <fcntl.h>
#include <stdlib.h>
#include <unistd.h>
#include <time.h>
#include <signal.h>
#include <sys/ioctl.h>
#include <sys/time.h>
#include <machine/console.h>
#include <machine/cpufunc.h>
#include <stdio.h>

#define CLKPORT		0x3e0
#define PPS_MHZ		10
#define PPS_BYTE0       0
#define PPS_BYTE1       1
#define PPS_BYTE2       2
#define PPS_EN_LATCH    3
#define PPS_DIS_LATCH   4
#define PPS_DIS_IRQ     5
#define PPS_EN_IRQ      6
#define PPS_RES_IRQ     7

#if __FreeBSD__ >= 3
# define GETTIMEOFDAY_OFFSET 5
#else
# define GETTIMEOFDAY_OFFSET 6
#endif

int ttyFd;


/*
 * Terminate the program.
 */
static void Terminate( int sig )
{

  signal(SIGTERM, SIG_DFL);
  if( ioctl( ttyFd, KDDISABIO, 0 ) < 0 ) {
    printf( "Can't disable iopl\n" );
    exit( 0 );
  }
  close( ttyFd );
  exit( 0 );

}

main(argc, argv)
int argc;
char *argv[];

{
  struct timeval tm;
  int SleepVal;
  long HwUs, Diff, AltDiff1, AltDiff2;
  char *tString;

  if( argc < 2 ) {
    printf( "Usage: %s seconds ( number of seconds between readings ).\n",
	    argv[ 0 ] );
    exit( 1 );
  }
  if( sscanf( argv[ 1 ], "%d", &SleepVal ) != 1 ) {
    printf( "Usage: %s seconds ( number of seconds between readings ).\n",
	    argv[ 0 ] );
    exit( 1 );
  }
  if( SleepVal < 1 ) {
    printf( "Usage: %s seconds ( number of seconds between readings ).\n",
	    argv[ 0 ] );
    exit( 1 );
  }
  if( ( ttyFd = open( "/dev/ttyv0", O_RDWR ) ) < 0 ) {
    printf( "%s: Can't open /dev/ttyv0\n", argv[ 0 ] );
    exit( 1 );
  }
  if( ioctl( ttyFd, KDENABIO, 0 ) < 0 ) {
    printf( "%s: Can't acquire iopl\n", argv[ 0 ] );
    exit( 1 );
  }
  (void)signal(SIGTERM, Terminate);
  (void)signal(SIGINT, Terminate);
  (void)signal(SIGQUIT, Terminate);
  gettimeofday( &tm, NULL );		/* Preload stuff in libc */
  for( ; ; ) {
    inb( CLKPORT + PPS_DIS_LATCH );
    gettimeofday( &tm, NULL );
    HwUs = (long)(inb( CLKPORT + PPS_BYTE0 ) & 0xff);
    HwUs = (long)(( inb( CLKPORT + PPS_BYTE1 ) & 0xff ) << 8) | HwUs;
    HwUs = (long)(( inb( CLKPORT + PPS_BYTE2 ) & 0xff ) << 16) | HwUs;
    HwUs /= PPS_MHZ;
    inb( CLKPORT + PPS_EN_LATCH );
    tm.tv_usec -= GETTIMEOFDAY_OFFSET;
    Diff = tm.tv_usec - HwUs;
    AltDiff1 = ( tm.tv_usec + 1000000L ) - HwUs;
    AltDiff2 = tm.tv_usec - ( HwUs + 1000000L );
    if( abs( (int)(AltDiff1) ) < abs( (int)(Diff) ) )
      Diff = AltDiff1;

    if( abs( (int)(AltDiff2) ) < abs( (int)(Diff) ) )
      Diff = AltDiff2;

    tString = asctime( localtime( (time_t *)(&tm.tv_sec) ) );
    tString[ strlen( tString ) - 1 ] = '\0';
    printf( "%s Diff : %7ld  HwCount : %7ld  SysTime : %7ld\n",
	    tString, Diff, HwUs, tm.tv_usec );
    fflush( stdout );
    sleep( SleepVal );
  }

}
