#include <fcntl.h>
#include <stdlib.h>
#include <unistd.h>
#include <time.h>
#include <signal.h>
#include <sys/ioctl.h>
#include <sys/time.h>
#include <sys/ppsclock.h>
#include <machine/console.h>
#include <machine/cpufunc.h>
#include <stdio.h>

int PpsFd;


/*
 * Terminate the program.
 */
static void Terminate( int sig )
{

  signal(SIGTERM, SIG_DFL);
  close( PpsFd );
  exit( 0 );

}

main(argc, argv)
int argc;
char *argv[];

{
  struct timeval tm;
  struct ppsclockev ClockEv;
  int SleepVal;
  long Diff;
  char *tString;

  if( argc < 2 ) {
    printf( "Usage: %s seconds ( number of seconds between readings ).\n",
	    argv[ 0 ] );
    exit( 1 );
  }
  if( sscanf( argv[ 1 ], "%d", &SleepVal ) != 1 ) {
    printf( "Usage: %s seconds ( number of seconds between readings ).\n",
	    argv[ 0 ] );
    exit( 1 );
  }
  if( SleepVal < 1 ) {
    printf( "Usage: %s seconds ( number of seconds between readings ).\n",
	    argv[ 0 ] );
    exit( 1 );
  }
  if( ( PpsFd = open( "/dev/ppsd0", O_RDWR ) ) < 0 ) {
    printf( "%s: Can't open /dev/ppsd0\n", argv[ 0 ] );
    exit( 1 );
  }
  (void)signal(SIGTERM, Terminate);
  (void)signal(SIGINT, Terminate);
  (void)signal(SIGQUIT, Terminate);
  for( ; ; ) {
    if (ioctl(PpsFd, CIOGETEV, (caddr_t)&ClockEv) < 0) {
      printf( "%s: Can't read clockevent\n", argv[ 0 ] );
      close( PpsFd );
      exit( 1 );
    }
    Diff = ClockEv.tv.tv_usec;
    if( Diff > 500000L )
      Diff -= 1000000L;

    gettimeofday( &tm, NULL );
    tString = asctime( localtime( (time_t *)(&tm.tv_sec) ) );
    tString[ strlen( tString ) - 1 ] = '\0';
    printf( "%s Diff : %7ld\n", tString, Diff );
    fflush( stdout );
    sleep( SleepVal );
  }

}
