/*
 * checkntp.h
 * Header file for ntp packet filter.
 *
 * Date : 00-01-13
 */

#ifndef _CHECKNTP_H
#define _CHECKNTP_H

/*
 * Struct holding 8 integer counters.
 */
struct NtpCnt { unsigned int Counter[ 8 ]; };

/*
 * Ioctl definitions.
 */
#define	SIOCIP_NTPALLOWMODE	_IOW('i', 90, int)
#define	SIOCIP_NTPDISALLOWMODE	_IOW('i', 91, int)
#define	SIOCIP_NTPCLEARMODES	_IO('i', 92)
#define	SIOCIP_NTPREADMODE	_IOR('i', 93, int)
#define	SIOCIP_NTPREADCOUNTERS	_IOR('i', 94, struct NtpCnt)
#define	SIOCIP_NTPCLEARCOUNTERS	_IO('i', 95)


/*
 * Prototypes needed by kernel code.
 */
#ifdef KERNEL
int     CheckNtpIoctl(struct socket *, int, caddr_t);
int	CheckNtp( struct mbuf *, int );
#endif

#endif /* _CHECKNTP_H */
