#include <sys/param.h>
#include <sys/systm.h>
#include <sys/kernel.h>
#include <sys/malloc.h>
#include <sys/mbuf.h>
#include <sys/proc.h>
#include <sys/protosw.h>
#include <sys/socket.h>
#include <sys/socketvar.h>
#include <sys/sysctl.h>
#include <sys/ioccom.h>

#include <vm/vm_zone.h>

#include <net/if.h>
#include <net/route.h>

#include <netinet/in.h>
#include <netinet/in_systm.h>
#include <netinet/ip.h>
#include <netinet/in_pcb.h>
#include <netinet/in_var.h>
#include <netinet/ip_var.h>
#include <netinet/ip_icmp.h>
#include <netinet/icmp_var.h>
#include <netinet/udp.h>
#include <netinet/udp_var.h>

#include "opt_checkntp.h"
#include <net/checkntp.h>

/*
 * A request packet.  These are almost a fixed length.
 */
struct req_pkt {
        u_char rm_vn_mode;              /* response, more, version, mode */
        u_char auth_seq;                /* key, sequence number */
        u_char implementation;          /* implementation number */
        u_char request;                 /* request number */
        u_short err_nitems;             /* error code/number of data items */
        u_short mbz_itemsize;           /* item size */
#if 0
        char data[32];                  /* data area */
        l_fp tstamp;                    /* time stamp, for authentication */
        U_LONG keyid;                   /* encryption key */
        char mac[MAX_MAC_LEN-sizeof(U_LONG)]; /* (optional) 8 byte auth code */
#endif
};

static u_char AllowedModes[ 8 ] = { 0, 0, 0, 1, 1, 0, 0, 0 };
static u_int PktCounters[ 8 ] = { 0, 0, 0, 0, 0, 0, 0, 0 };


/*
 * Ioctl entrypoint.
 */
int CheckNtpIoctl(so, cmd, data)
  struct socket *so;
  int cmd;
  caddr_t data;
{
  int *InPnt = (int *)data;
  struct proc *p = curproc;
  int error, i, Modes;

  if (error = suser(p))
    return (error);

  switch (cmd) {
    case SIOCIP_NTPALLOWMODE:
      /*
       * Allow another packet mode in.
       */
      if( *InPnt < 8 && *InPnt >= 0 )
	AllowedModes[ *InPnt ] = 1;
      else
	return( EINVAL );

      break;

    case SIOCIP_NTPDISALLOWMODE:
      /*
       * Disallow another packet mode in.
       */
      if( *InPnt < 8 && *InPnt >= 0 )
	AllowedModes[ *InPnt ] = 0;
      else
	return( EINVAL );

      break;

    case SIOCIP_NTPCLEARMODES:
      /*
       * Disallow all packet mode in.
       */
      bzero( AllowedModes, sizeof AllowedModes );
      break;

    case SIOCIP_NTPREADMODE:
      /*
       * Read present mode bits.
       */
      Modes = 0;
      for( i = 0; i < 8; i++ ) {
	Modes = Modes >> 1;
	if( AllowedModes[ i ] )
	  Modes |= 0x80;
      }
      *InPnt = Modes;
      break;

    case SIOCIP_NTPREADCOUNTERS:
      /*
       * Read present packet counters.
       */
      for( i = 0; i < 8; i++ )
	((struct NtpCnt *)(InPnt))->Counter[ i ] = PktCounters[ i ];

      break;

    case SIOCIP_NTPCLEARCOUNTERS:
      /*
       * Clear packet counters.
       */
      bzero( PktCounters, sizeof PktCounters );
      break;

  default:
      printf("CheckNtpIoctl: unknown cmd %x\n", cmd);
      return( EINVAL );
  }
  return(0);

}



int CheckNtp( struct mbuf *m, int iphlen )
{
  struct ip *ip;
  struct udphdr *uh;
  struct req_pkt ntp;
  unsigned char *cp;

#if 0
  if( m->m_len < iphlen + sizeof( struct udphdr ) + sizeof ntp ) {
    if( ( m = m_pullup( m, iphlen + sizeof( struct udphdr ) + sizeof ntp ) ) == 0 )
      return( 1 );
  }
#endif
  ip = mtod( m, struct ip * );
  uh = (struct udphdr *)((caddr_t)ip + iphlen);
  cp = mtod( m, char * );
  cp += ( iphlen + sizeof( struct udphdr ) );
  bcopy( cp, (char *)(&ntp), sizeof ntp );
  if( m->m_flags & M_PKTHDR ) {
    if( m->m_pkthdr.rcvif != 0 ) {
      if( strcmp( "lo", m->m_pkthdr.rcvif->if_name ) != 0 ) {
	if( AllowedModes[ ntp.rm_vn_mode & 0x07 ] != 0 ) {
	  PktCounters[ ntp.rm_vn_mode & 0x07 ]++;
	  return( 0 );
	}
	else
	  return( 1 );
      }
      else
	return( 0 );
    }
  }
  return( 1 );

}
