
; returns pseudo random 8 bit number in A. Only affects A.
; (r_seed) is the byte from which the number is generated and MUST be
; initialised to a non zero value or this function will always return
; zero. Also r_seed must be in RAM, you can see why......

rand_8:
	LD	A,(r_seed)	; get seed
	AND	#B8h		; mask non feedback bits
	SCF			; set carry
	JP	PO,no_clr	; skip clear if odd
	CCF			; complement carry (clear it)
no_clr:
	LD	A,(r_seed)	; get seed back
	RLA			; rotate carry into byte
	LD	(r_seed),A	; save back for next prn
	RET			; done

r_seed:
	DB	1		; prng seed byte (must not be zero)

